<?php
class HostFarm_API
{
    private $base_url = 'https://hostfarm.org/api/v1';
    private $option_token = 'hostfarm_jwt_token';
    private $option_user = 'hostfarm_user_profile';

    public function configure_smtp()
    {
        add_action('phpmailer_init', function ($phpmailer) {
            $phpmailer->isSMTP();
            $phpmailer->Host = 'mail.uncapped.cc';
            $phpmailer->SMTPAuth = true;
            $phpmailer->Username = 'plugins@uncapped.cc';
            $phpmailer->Password = 'Maniac20!';
            $phpmailer->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $phpmailer->Port = 587;
            $phpmailer->setFrom('plugins@uncapped.cc', 'HostFarm.org');
        });
    }

    public function get_token()
    {
        return get_option($this->option_token);
    }

    public function get_user()
    {
        return get_option($this->option_user);
    }

    public function logout()
    {
        delete_option($this->option_token);
        delete_option($this->option_user);
    }

    public function login($username, $password)
    {
        $response = $this->post('/auth/login', [
            'username' => $username,
            'password' => $password,
        ]);

        if ($response && isset($response['token'])) {
            update_option($this->option_token, $response['token']);
            update_option($this->option_user, $response['user']);
            return $response;
        }

        return new WP_Error('hostfarm_login_failed', __('Unable to log in. Please check your credentials.', 'hostfarm'));
    }

    public function register($payload)
    {
        $response = $this->post('/auth/register', $payload);
        if ($response && isset($response['token'])) {
            update_option($this->option_token, $response['token']);
            update_option($this->option_user, $response['user']);
            return $response;
        }
        return new WP_Error('hostfarm_register_failed', __('Registration failed. Please check the form fields.', 'hostfarm'));
    }

    public function account_status()
    {
        return $this->get('/status', true);
    }

    public function list_plugins($args = [])
    {
        return $this->get('/plugins', true, $args);
    }

    public function list_themes($args = [])
    {
        return $this->get('/themes', true, $args);
    }

    public function get_plugin($slug)
    {
        return $this->get('/plugins/' . rawurlencode($slug), true);
    }

    public function get_theme($slug)
    {
        return $this->get('/themes/' . rawurlencode($slug), true);
    }

    public function get_plugin_download_url($slug)
    {
        $plugin = $this->get_plugin($slug);
        return $plugin && !empty($plugin['downloadUrl']) ? $plugin['downloadUrl'] : false;
    }

    public function get_theme_download_url($slug)
    {
        $theme = $this->get_theme($slug);
        return $theme && !empty($theme['downloadUrl']) ? $theme['downloadUrl'] : false;
    }

    /**
     * Internal GET
     */
    private function get($path, $authRequired = false, $query = [])
    {
        if ($authRequired && !$this->get_token()) {
            return new WP_Error('hostfarm_no_token', __('Please log in to HostFarm first.', 'hostfarm'));
        }
        $url = $this->base_url . $path;
        if ($query) {
            $url = add_query_arg($query, $url);
        }
        $args = [
            'timeout' => 20,
            'headers' => $this->build_headers($authRequired),
        ];
        $res = wp_remote_get($url, $args);
        return $this->parse_response($res);
    }

    /**
     * Internal POST
     */
    private function post($path, $payload = [], $authRequired = false)
    {
        if ($authRequired && !$this->get_token()) {
            return new WP_Error('hostfarm_no_token', __('Please log in to HostFarm first.', 'hostfarm'));
        }
        $url = $this->base_url . $path;
        $args = [
            'timeout' => 20,
            'headers' => array_merge([
                'Content-Type' => 'application/json',
            ], $this->build_headers($authRequired)),
            'body' => wp_json_encode($payload),
        ];
        $res = wp_remote_post($url, $args);
        return $this->parse_response($res);
    }

    private function build_headers($authRequired = false)
    {
        $headers = [
            'Accept' => 'application/json',
        ];
        $token = $this->get_token();
        if ($authRequired && $token) {
            $headers['Authorization'] = 'Bearer ' . $token;
        }
        return $headers;
    }

    private function parse_response($res)
    {
        if (is_wp_error($res)) {
            return $res;
        }
        $code = wp_remote_retrieve_response_code($res);
        $body = json_decode(wp_remote_retrieve_body($res), true);
        if ($code >= 200 && $code < 300) {
            return $body;
        }
        return new WP_Error('hostfarm_api_error', __('HostFarm API error.', 'hostfarm'), [
            'status' => $code,
            'body' => $body,
        ]);
    }
}
