<?php
/**
 * Plugin Name: HostFarm
 * Description: HostFarm catalogue browser for WordPress plugins & themes with one-click install/update via HostFarm API.
 * Version: 1.1.1
 * Author: HostFarm
 * Text Domain: hostfarm
 */

if (!defined('ABSPATH')) {
    exit;
}

define('HOSTFARM_VERSION', '1.1.1');
define('HOSTFARM_CHANGELOG_VERSION', '1.1.1');
define('HOSTFARM_PLUGIN_FILE', __FILE__);
define('HOSTFARM_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('HOSTFARM_PLUGIN_URL', plugin_dir_url(__FILE__));
define('HOSTFARM_MONITOR_URL', 'https://hostfarm.pluginfarm.com/admin/api/log.php');
define('HOSTFARM_MONITOR_TOKEN', 'hostfarm-monitor-secret');
define('HOSTFARM_PRIMARY_HOST', 'plugin.hostfarm.org');

hostfarm_load_files();

function hostfarm_load_files()
{
    require_once HOSTFARM_PLUGIN_DIR . 'includes/class-hostfarm-api.php';
    require_once HOSTFARM_PLUGIN_DIR . 'includes/class-hostfarm-admin.php';
    require_once HOSTFARM_PLUGIN_DIR . 'includes/class-hostfarm-updater.php';
}

function hostfarm_bootstrap()
{
    $api = new HostFarm_API();
    $admin = new HostFarm_Admin($api);
    $updater = new HostFarm_Updater($api);

    // Ensure HostFarm JWT accompanies outbound requests to HostFarm endpoints (including ZIP downloads)
    add_filter('http_request_args', function ($args, $url) use ($api) {
        $host = wp_parse_url($url, PHP_URL_HOST);
        if (!$host) {
            return $args;
        }
        if (stripos($host, 'hostfarm.org') !== false) {
            $token = $api->get_token();
            if ($token) {
                $args['headers']['Authorization'] = 'Bearer ' . $token;
            }
        }
        return $args;
    }, 10, 2);
}
add_action('plugins_loaded', 'hostfarm_bootstrap');

// ensure 5-minute cron remains scheduled
add_action('init', function () {
    if (!wp_next_scheduled('hostfarm_cron_version_check')) {
        wp_schedule_event(time(), 'every5', 'hostfarm_cron_version_check');
    }
});

// add 5-minute interval
add_filter('cron_schedules', function ($schedules) {
    if (!isset($schedules['every5'])) {
        $schedules['every5'] = [
            'interval' => 300,
            'display' => __('Every 5 minutes', 'hostfarm'),
        ];
    }
    return $schedules;
});

/**
 * Schedule recurring cron for version checks (12h).
 */
function hostfarm_activate()
{
    if (!wp_next_scheduled('hostfarm_cron_version_check')) {
        wp_schedule_event(time(), 'every5', 'hostfarm_cron_version_check');
    }
}
register_activation_hook(__FILE__, 'hostfarm_activate');

function hostfarm_deactivate()
{
    wp_clear_scheduled_hook('hostfarm_cron_version_check');
}
register_deactivation_hook(__FILE__, 'hostfarm_deactivate');
